﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using Gemini.Core.BL.Interface;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        internal class MethodUsersLogout : BaseAPIMethod
        {

            public MethodUsersLogout(ELearning Component)
                : base(Component)
            {
            }

            public override string Name
            {
                get { return "userslogout"; }
            }

            protected override bool DoValidate()
            {
                return true;
            }

            protected override void DoReadRequestParams()
            {
                //nic nie musimy czytac w sumie
            }

            protected override GResponseData DoGetGResponseData()
            {
                if (Session != null)
                {
                    StatusCode = StatusCodeType.OK;
                    Component.Environment.SessionManager.Close(Session);
                    return new GResponseData();
                }
                else
                {
                    AddErrorMessage("Brak sesji użytkownika.");
                    StatusCode = StatusCodeType.NotFound;
                }
                return null;
            }
        }
    }
}